@php
    use Illuminate\Support\Facades\Request;

    $empIdEncrypted = Request::get('emp');

    try {
        $empId = decrypt($empIdEncrypted);
    } catch (\Exception $e) {
        abort(403, 'Invalid Employee ID');
    }
    //multi language disable
    // $locale = app()->getLocale();
    $locale = 'ar';
    app()->setLocale('ar');

    function convertToArabicNumbers($string)
    {
        $western = range(0, 9);
        $eastern = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
        return str_replace($western, $eastern, $string);
    }

    $rawAr = \Carbon\Carbon::now()->locale('ar')->translatedFormat('d F Y - h:i A');
    $dateAr = convertToArabicNumbers($rawAr);
    $dateEn = \Carbon\Carbon::now()->locale('en')->translatedFormat('d F Y - h:i A');

    $website = env('APP_URL', 'https://orascom.com');
    $documentId = 'DOC-' . now()->format('Ymd-His') . '-' . Str::upper(Str::random(4));

    $employee = \App\Models\User\UserEmployee::with('user')->findOrFail($empId);
    $cv = is_array($employee->cv) ? $employee->cv : json_decode($employee->cv, true);

    $full_name_ar = $employee->full_name['ar'] ?? '';
    $full_name_en = $employee->full_name['en'] ?? '';
    $email = $employee->user?->email ?? '';
    $profile_picture_path = $cv['profile_picture'] ?? null;
    $experience_roads = $cv['work_experience']['roads'] ?? [];
    $experience_airports = $cv['work_experience']['airports'] ?? [];
    $skills = $cv['skills'] ?? [];
    $phone = $employee->phone ? json_decode($employee->phone, true)[0] ?? '' : '';
    $job = $locale === 'ar' ? optional($employee->jobTitle)->title_ar : optional($employee->jobTitle)->title_en;

    $job_title = $job ?? ($locale === 'ar' ? 'موظف' : 'Employee');

    $languages = $cv['languages'] ?? [];
    $certificates = $cv['certificates'] ?? [];
    $graduation_project = $cv['graduation_project'] ?? '';
@endphp

<!DOCTYPE html>
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $locale === 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="UTF-8">
    <title>{{ __('frontend.cv') }}</title>
    <style>
        html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
            font-family: 'Cairo', 'Amiri', sans-serif;
            font-size: 13px;
            color: #333;
            background: #fff;
        }

        .container {
            display: table;
            width: 100%;
            table-layout: fixed;
            border-collapse: collapse;
        }

        .left-column {
            display: table-cell;
            background-color: #909090;
            color: white;
            border-radius: 25px;
            border: 4px solid #fff;
            padding: 40px 30px;
            /* بدل 25px 20px → نزودها شوية */
            height: 100%;
            width: 30%;
            vertical-align: top;
            text-align: center;
            position: relative;
            overflow: hidden;
            box-sizing: border-box;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }


        .right-column {
            display: table-cell;
            background-color: #909090;
            color: white;
            border-radius: 25px;
            border: 4px solid #fff;
            padding: 40px 30px;
            /* بدل 25px 20px → نزودها شوية */
            height: 100%;
            width: 70%;
            vertical-align: top;
            text-align: center;
            position: relative;
            overflow: hidden;
            box-sizing: border-box;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }



        .right-column2 {
            display: table-cell;
            color: black;
            border-radius: 25px;
            /* جرب 12px / 20px / 25px حسب الذوق */
            padding: 25px 20px;
            height: 100%;
            width: 70%;
            vertical-align: top;
            padding: 20px;
            text-align: center;
            position: relative;
            overflow: hidden;
            /* شيل اللون من هنا */
            box-sizing: border-box;
            flex-direction: column;
            align-items: center;
            justify-content: flex-start;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }



        .profile-pic {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 5px solid #fff;
            margin-bottom: 10px;
        }

        .section-title {
            font-size: 15px;
            margin-top: 15px;
            margin-bottom: 10px;
            border-bottom: 1px solid white;
            padding-bottom: 5px;
            font-weight: bold;
            width: 100%;
        }

        .right-section-title {
            font-size: 18px;
            color: #333;
            border-bottom: 2px solid #ccc;
            padding-bottom: 5px;
            font-weight: bold;
            margin-top: 20px;
            margin-bottom: 10px;
        }

        .experience-item {
            padding: 10px 12px;
            background: #fafafa;
            border-radius: 8px;
            border: 1px solid #eee;
            font-size: 13px;
            line-height: 1.6;
            margin-bottom: 8px;
        }

        .skills-list {
            list-style: none;
            padding: 0;
            margin: 0;
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            justify-content: center;
        }

        .skills-list li {
            background: #fafafa;
            color: #333;
            padding: 7px 14px;
            border-radius: 20px;
            border: 1px solid #ccc;
            font-weight: bold;
            font-size: 12px;
        }

        footer {
            grid-column: 1 / -1;
            font-size: 11px;
            color: #555;
            padding: 12px;
            border-top: 1px solid #ccc;
            text-align: center;
            background: #f9f9f9;
        }

        table {
            width: 100%;
            height: 100vh;
            /* او 297mm لو عايز A4 ثابتة بالـ mm */
            table-layout: fixed;
            border-collapse: collapse;
        }

        td {
            vertical-align: top;
            height: 100%;
        }
    </style>
</head>

<body>
    <table style="width:100%; table-layout:fixed; border-collapse:collapse;">
        <tr>
            <!-- Left Column -->
            <td class="left-column" rowspan="2">



                @if (!empty($profile_picture_path) && file_exists(public_path('storage/' . $profile_picture_path)))
                    <img src="{{ public_path('storage/' . $profile_picture_path) }}" class="profile-pic"
                        alt="Profile Picture">
                @else
                    <img src="{{ public_path('assets/img/default-avatar.png') }}" class="profile-pic"
                        alt="Profile Picture">
                @endif



                <div class="section-title">{{ __('frontend.contact_information') }}</div>
                <div class="info-item">📱 +20{{ $phone }}</div>
                <div class="info-item">📧 {{ $email }}</div>


                <div class="section-title">{{ __('frontend.skills') }}</div>
                @if (!empty($skills))
                    <ul class="skills-list">
                        @foreach ($skills as $skill)
                            <li>{{ $skill }}</li>
                        @endforeach
                    </ul>
                @else
                    <div class="info-item">{{ __('frontend.no_skills') }}</div>
                @endif

                <div class="section-title">{{ __('frontend.languages') }}</div>
                @if (!empty($languages))
                    <ul class="skills-list">
                        @foreach ($languages as $lang)
                            <li>{{ $lang }}</li>
                        @endforeach
                    </ul>
                @else
                    <div class="info-item">{{ __('frontend.no_languages') }}</div>
                @endif

                <div class="section-title">{{ __('frontend.certificates') }}</div>
                @if (!empty($certificates))
                    <ul class="skills-list">
                        @foreach ($certificates as $cert)
                            <li>{{ $cert }}</li>
                        @endforeach
                    </ul>
                @else
                    <div class="info-item">{{ __('frontend.no_certificates') }}</div>
                @endif

            </td>

            <td class="right-column">


                <div style="flex: 0 0 30%; padding: 30px;">
                    <div style=" text-align: center;">
                        <h1 style="  font-size: 24px;  margin: 0 0 10px 0; ">
                            {{ $full_name_ar }}
                        </h1>

                        <div
                            style=" display: flex; align-items: center; justify-content: center;  font-size: 16px;  color: #e9e9e9; font-weight: bold; ">
                            <svg xmlns="http://www.w3.org/2000/svg"
                                style="width:20px; height:20px; vertical-align:middle; margin-left:8px;"
                                fill="currentColor" viewBox="0 0 16 16">
                                <path
                                    d="M6.5 0a1 1 0 0 0-1 1V2h-2A2.5 2.5 0 0 0 1 4.5v9A2.5 2.5 0 0 0 3.5 16h9a2.5 2.5 0 0 0 2.5-2.5v-9A2.5 2.5 0 0 0 12.5 2h-2V1a1 1 0 0 0-1-1h-3zm1 1h3v1h-3V1zM3.5 3h9A1.5 1.5 0 0 1 14 4.5V6H2V4.5A1.5 1.5 0 0 1 3.5 3zM2 7h12v6.5a1.5 1.5 0 0 1-1.5 1.5h-9A1.5 1.5 0 0 1 2 13.5V7z" />
                            </svg>
                            {{ $job_title }}
                        </div>
                    </div>
                </div>


            </td>
        </tr>

        <tr>
            <td class="right-column2">

                <!-- Right Column -->
                <div style="flex: 1 1 70%;width: 100%; padding: 30px; background-color: white;">
                    <h1 style="color: #0d6efd; margin-bottom: 15px;">{{ __('frontend.cv') }}</h1>

                    <div class="right-section-title">{{ __('frontend.roads_experience') }}</div>
                    @forelse($experience_roads as $exp)
                        <div class="experience-item">
                            <strong>{{ $exp['name'] }}</strong><br>
                            📅 {{ __('frontend.start_date') }}: {{ $exp['start_date'] }} -
                            {{ __('frontend.end_date') }}:
                            {{ $exp['end_date'] }}<br>
                            📝 <em>{{ $exp['description'] }}</em>
                        </div>
                    @empty
                        <div>{{ __('frontend.no_experience') }}</div>
                    @endforelse

                    <div class="right-section-title">{{ __('frontend.airports_experience') }}</div>
                    @forelse($experience_airports as $exp)
                        <div class="experience-item">
                            <strong>{{ $exp['name'] }}</strong><br>
                            📅 {{ __('frontend.start_date') }}: {{ $exp['start_date'] }} -
                            {{ __('frontend.end_date') }}:
                            {{ $exp['end_date'] }}<br>
                            📝 <em>{{ $exp['description'] }}</em>
                        </div>
                    @empty
                        <div>{{ __('frontend.no_experience') }}</div>
                    @endforelse

                    <div class="right-section-title">{{ __('frontend.graduation_project') }}</div>
                    @if (!empty($graduation_project))
                        <div class="experience-item">
                            📝 <em>{{ $graduation_project }}</em>
                        </div>
                    @else
                        <div>{{ __('frontend.no_graduation_project') }}</div>
                    @endif
                </div>

            </td>
        </tr>
    </table>
    <!-- Footer -->
    <footer>
        {{ __('frontend.hrmanager') }} - {{ __('backend.eng_name') }} |
        {{ __('frontend.document_id') }} {{ $documentId }} |
        🌐 {{ $website }} |
        📄 1/1
    </footer>

    </div>
</body>

</html>
